<?php 
include_once("../modelo/Expediente.php");
$objExp = new Expediente();
$filtro = $_POST['filtro'];

$listadoModal = $objExp->listarExpedienteModal($filtro);
?>
<table id="tablaExpediente" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>N° EXP</th>
            <th>Nombre Doc</th>
            <th>Ver</th>
            <th>Elim</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listadoModal as $k=>$v){ ?>
            <tr>
                <td><?= $v['id'] ?></td>
                <td><?= $v['idexpediente'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><a  href="<?= $v['link'] ?>" target="_blank" class="btn bg-success btn-sm" ><span class="fas fa-print" ></span></button></td>></a></td>
                <td><button onclick="CambiarEstadoExpediente(<?= $v['id'] ?>,<?= $v['idexpediente'] ?>,2,'<?= $v['nombre'] ?>')"class="btn bg-danger btn-sm"><span class="fas fa-trash" ></span></button></td>
            </tr>
        <?php }?>
    </tbody>
</table>

<script>
    function CambiarEstadoExpediente(idlink,idexpediente, estado, nroexpediente){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR_LINK");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> el expediente <b>"+nroexpediente+"</b>?";
    accion = "EjecutarCambiarEstadoExpediente("+idlink+","+idexpediente+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoExpediente(idlink,idexpediente,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data: {
            'proceso': proceso,
            'idexpediente': idexpediente,
            'id': idlink
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Link eliminado correctamente.");
            listarExpedientes();
        }else{
            toastError("Problemas en la eliminación del documento. Inténtelo nuevamente.");
        }
    });
}
</script>