<?php 
include_once("../modelo/Expediente.php");
$objExp = new Expediente();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$origen = $_POST['origen'];
$idareaorigen = $_POST['idareaorigen'];
$listado = $objExp->listar("%".$filtro."%",$estado,$origen,$idareaorigen);
?>
<table id="tablaExpediente" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Cliente</th>
            <th>N° Doc</th>
            <th>Asunto</th>
            <th>Detalle</th>
            <th>Adjunt</th>
            <th>Gestión</th>
           
            
            <th>Editar</th>
            <th>Const.</th>
            <th>Eliminar</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==1?"Anular":"Activar";
            $estado = $v['estado']==1?0:1;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idexpediente'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['nroexpediente'] ?></td>
                <td><?= $v['asunto'] ?></td>
                <td><?= $v['detalle'] ?></td>
                <td><button onclick="SubirDocumento(<?= $v['idexpediente'] ?>)" class="btn bg-navy btn-sm" ><span class="fas fa-paperclip" ></span></button></td>
                <td><?= $v['proveido'] ?></td>
               
                
                <td><button onclick="EditarExpediente(<?= $v['idexpediente'] ?>)" class="btn bg-info btn-sm"><span class="fas fa-edit" ></span></button></td>
                <td><button onclick="imprimirConstancia(<?= $v['idexpediente'] ?>)" class="btn bg-success btn-sm"><span class="fas fa-print" ></span></button></td>
                <td><button onclick="CambiarEstadoExpediente(<?= $v['idexpediente'] ?>,2,'<?= $v['nroexpediente'] ?>')" class="btn bg-danger btn-sm"><span class="fas fa-trash-alt" ></span></button></td>
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaExpediente').DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[0,'desc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaExpediente_wrapper .col-md-6:eq(0)');

function EditarExpediente(idexpediente){
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data:{
            'proceso': "CONSULTAR",
            'idexpediente': idexpediente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idexpediente").val(resultado.idexpediente);
        $("#origen").val(resultado.origen);
        $("#idcliente").val(resultado.idcliente);
        $("#fechasys").val(resultado.fechasys);
        $("#fechaexpediente").val(resultado.fechaexpediente);
        $("#idtipodoc").val(resultado.idtipodoc);
        $("#nroexpediente").val(resultado.nroexpediente);
        $("#asunto").val(resultado.asunto);
        $("#detalle").val(resultado.detalle);
        $("#folios").val(resultado.folios);
        $("#link").val(resultado.link);
        $("#diasatencion").val(resultado.diasatencion);
        $("#idarea").val(resultado.idarea);
        $("#idtramite").val(resultado.idtramite);
        $("#proveido").val(resultado.proveido);
        $("#estado").val(resultado.estado);
        $("#idtipodocumento").val(EditarCliente(resultado.idcliente));
        
        $("#modalExpediente").modal('show');
    });
}

function imprimirConstancia(idexpediente){
        window.open("vista/pdfConstanciaExpediente.php?expediente="+idexpediente,"_blank");    
}

function EditarCliente(idcliente){
    $.ajax({
        method: "POST",
        url: "controlador/contCliente.php",
        data:{
            'proceso': "CONSULTAR",
            'idcliente': idcliente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#nombre").val(resultado.nombre);
        $("#idtipodocumento").val(resultado.idtipodocumento);
        $("#nrodocumento").val(resultado.nrodocumento);
        $("#direccion").val(resultado.direccion);
        $("#estado").val(resultado.estado);
        $("#idcliente").val(resultado.idcliente);
        $("#modalCliente").modal('show');
    });
}

function CambiarEstadoExpediente(idexpediente, estado, nroexpediente){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> el expediente <b>"+nroexpediente+"</b>?";
    accion = "EjecutarCambiarEstadoExpediente("+idexpediente+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoExpediente(idexpediente,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data: {
            'proceso': proceso,
            'idexpediente': idexpediente
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarExpedientes();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}

function SubirDocumento(idexpediente){
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data:{
            'proceso': "CONSULTAR",
            'idexpediente': idexpediente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idexpediente_documento").val(resultado.idexpediente);
        $("#nombre_documento").val(resultado.nombre);
        $("#urdocumento").val(resultado.urldocumento);
        DefinirFileInput();
        $("#modaldocumento").modal('show');
        listarExpedientesModal();
    });
}
</script>