<?php
include_once("conexion.php");

class Producto{

    function listar($nombre, $estado){
        $sql = "SELECT * FROM producto WHERE estado<2 AND nombre LIKE :nombre ";
        $parametros = array(':nombre'=>$nombre);
        if($estado!=""){
            $sql.=" AND estado=:estado ";
            $parametros[':estado']=$estado;
        }
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function consultarProducto($idproducto){
        $sql = "SELECT * FROM producto WHERE idproducto=? ";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($idproducto));
        return $pre;
    }

    function consultarProductoNombre($nombre,$codigbarra, $idproducto=0){
        $sql = "SELECT * FROM producto WHERE (nombre=? OR codigobarra=?) AND idproducto<>?";
        global $cnx;
        $pre = $cnx->prepare($sql);
        $pre->execute(array($nombre,$codigbarra,$idproducto));
        return $pre;
    } 

    function insertar($producto){
        $sql = "INSERT INTO producto(idproducto, nombre, codigobarra, pventa, pcompra, stock, idunidad, idcategoria, idafectacion, afectoicbper, estado) 
                VALUES (NULL,:nombre, :codigobarra, :pventa, :pcompra, :stock, :idunidad, :idcategoria, :idafectacion,:afectoicbper, :estado)";
        global $cnx;
        $parametros = array(
            ":nombre"        =>$producto['nombre'], 
            ":codigobarra"   =>$producto['codigobarra'], 
            ":pventa"        =>$producto['pventa'], 
            ":pcompra"       =>$producto['pcompra'],  
            ":stock"         =>$producto['stock'], 
            ":idunidad"      =>$producto['idunidad'], 
            ":idcategoria"   =>$producto['idcategoria'], 
            ":idafectacion"  =>$producto['idafectacion'], 
            ":afectoicbper"  =>$producto['afectoicbper'],
            ":estado"        =>$producto['estado']
        );
        $pre = $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizar($producto){
        $sql = "UPDATE producto 
                SET nombre=:nombre, 
                    codigobarra=:codigobarra, 
                    pventa=:pventa, 
                    pcompra=:pcompra, 
                    stock=:stock, 
                    idunidad=:idunidad, 
                    idcategoria=:idcategoria, 
                    idafectacion=:idafectacion, 
                    afectoicbper=:afectoicbper,
                    estado=:estado 
                WHERE idproducto=:idproducto";
        global $cnx;
        $parametros = array(
            ":idproducto"   =>$producto['idproducto'],
            ":nombre"        =>$producto['nombre'], 
            ":codigobarra"   =>$producto['codigobarra'], 
            ":pventa"        =>$producto['pventa'], 
            ":pcompra"       =>$producto['pcompra'],  
            ":stock"         =>$producto['stock'], 
            ":idunidad"      =>$producto['idunidad'], 
            ":idcategoria"   =>$producto['idcategoria'], 
            ":idafectacion"  =>$producto['idafectacion'], 
            ":afectoicbper"  =>$producto['afectoicbper'], 
            ":estado"        =>$producto['estado']
        );
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarEstado($idproducto, $estado){
        $sql = "UPDATE producto SET estado=:estado WHERE idproducto=:idproducto";
        global $cnx;
        $parametros = array(":idproducto"=>$idproducto, ":estado"=>$estado);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }

    function actualizarUrlimagen($idproducto, $urlimagen){
        $sql = "UPDATE producto SET urlimagen=:urlimagen WHERE idproducto=:idproducto";
        global $cnx;
        $parametros = array(":idproducto"=>$idproducto, ":urlimagen"=>$urlimagen);
        $pre= $cnx->prepare($sql);
        $pre->execute($parametros);
        return $pre;
    }
}

?>