<?php 
include_once("../modelo/TipoDocumento.php");
$objTipoDoc = new TipoDocumento();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$listado = $objTipoDoc->listarDocumentos("%".$filtro."%",$estado);
?>
<table id="tablaTipoDocumento" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Estado</th>
            <th>Editar</th>
            <th>Anular</th>
            <th>Eliminar</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==1?"Anular":"Activar";
            $estado = $v['estado']==1?0:1;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idtipodocumento'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['estado']==1?"ACTIVO":"INACTIVO"; ?></td>
                <td><button onclick="EditarTipoDocumento(<?= $v['idtipodocumento'] ?>)" class="btn bg-info btn-sm">Editar</button></td>
                <td><button onclick="CambiarEstadoTipoDocumento(<?= $v['idtipodocumento'] ?>,<?= $estado ?>,'<?= $v['nombre'] ?>')" class="btn <?= $bgclass ?> btn-sm"><?= $texto ?></button></td>
                <td><button onclick="CambiarEstadoTipoDocumento(<?= $v['idtipodocumento'] ?>,2,'<?= $v['nombre'] ?>')" class="btn bg-danger btn-sm">Eliminar</button></td>
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaTipoDocumento').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[1,'asc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaTipoDocumento_wrapper .col-md-6:eq(0)');

function EditarTipoDocumento(idtipodocumento){
    $.ajax({
        method: "POST",
        url: "controlador/contTipodocumento.php",
        data:{
            'proceso': "CONSULTAR",
            'idtipodocumento': idtipodocumento
        },
        dataType: "json"
    }).done(function(resultado){
        $("#nombre").val(resultado.nombre);
        $("#estado").val(resultado.estado);
        $("#idtipodocumento").val(resultado.idtipodocumento);
        $("#modalTipoDocumento").modal('show');
    });
}

function CambiarEstadoTipoDocumento(idtipodocumento, estado, nombre){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> el Tipo de Documento <b>"+nombre+"</b>?";
    accion = "EjecutarCambiarEstadoTipoDocumento("+idtipodocumento+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoTipoDocumento(idtipodocumento,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contTipodocumento.php",
        data: {
            'proceso': proceso,
            'idtipodocumento': idtipodocumento
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarTipoDocumentos();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}

</script>