<?php 
include_once("../modelo/Producto.php");
$objPro = new Producto();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$listado = $objPro->listar("%".$filtro."%",$estado);
?>
<table id="tablaProducto" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Im</th>
            <th>Nombre</th>
            <th>PV</th>
            <th>PC</th>
            <th>Estado</th>
            <th>Img</th>
            <th>Edit</th>
            <th>Anu</th>
            <th>Elim</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==1?"Anu":"Acti";
            $estado = $v['estado']==1?0:1;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idproducto'] ?></td>
                <td><img src="<?= $v['urlimagen'] ?>" width="30" height="30" /></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['pventa'] ?></td>
                <td><?= $v['pcompra'] ?></td>
                <td><?= $v['estado']==1?"ACTIVO":"INACTIVO"; ?></td>
                <td><button onclick="SubirImagen(<?= $v['idproducto'] ?>)" class="btn bg-navy btn-sm" ><span class="fas fa-image" ></span></button></td>
                <td><button onclick="EditarProducto(<?= $v['idproducto'] ?>)" class="btn bg-info btn-sm">Edit</button></td>
                <td><button onclick="CambiarEstadoProducto(<?= $v['idproducto'] ?>,<?= $estado ?>,'<?= $v['nombre'] ?>')" class="btn <?= $bgclass ?> btn-sm"><?= $texto ?></button></td>
                <td><button onclick="CambiarEstadoProducto(<?= $v['idproducto'] ?>,2,'<?= $v['nombre'] ?>')" class="btn bg-danger btn-sm">Elim</button></td>
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaProducto').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[1,'asc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaProducto_wrapper .col-md-6:eq(0)');

function EditarProducto(idproducto){
    $.ajax({
        method: "POST",
        url: "controlador/contProducto.php",
        data:{
            'proceso': "CONSULTAR",
            'idproducto': idproducto
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idproducto").val(resultado.idproducto);
        $("#nombre").val(resultado.nombre);
        $("#codigobarra").val(resultado.codigobarra);
        $("#pventa").val(resultado.pventa);
        $("#pcompra").val(resultado.pcompra);
        $("#stock").val(resultado.stock);
        $("#idunidad").val(resultado.idunidad);
        $("#idcategoria").val(resultado.idcategoria);
        $("#idafectacion").val(resultado.idafectacion);
        $("#afectoicbper").val(resultado.afectoicbper);
        $("#estado").val(resultado.estado);
        $("#modalProducto").modal('show');
    });
}

function CambiarEstadoProducto(idproducto, estado, nombre){
    proceso = estado==0?"ANULAR":(estado==1?"ACTIVAR":"ELIMINAR");
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> producto <b>"+nombre+"</b>?";
    accion = "EjecutarCambiarEstadoProducto("+idproducto+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoProducto(idproducto,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contProducto.php",
        data: {
            'proceso': proceso,
            'idproducto': idproducto
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarProductos();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}


function SubirImagen(idproducto){
    $.ajax({
        method: "POST",
        url: "controlador/contProducto.php",
        data:{
            'proceso': "CONSULTAR",
            'idproducto': idproducto
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idproducto_imagen").val(resultado.idproducto);
        $("#nombre_imagen").val(resultado.nombre);
        $("#urlimagen").val(resultado.urlimagen);
        DefinirFileInput();
        $("#modalImagen").modal('show');
    });
}
</script>