<?php 
include_once("../modelo/Expediente.php");
$objExp = new Expediente();
$filtro = $_POST['filtro'];
$estado = $_POST['estado'];
$idArea=$_SESSION['idarea'];

$listado = $objExp->listarEnProceso("%".$filtro."%",$estado,0,$idArea);
?>
<table id="tablaExpedProceso" class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>ID</th>
            <th>Fecha</th>
            <th>Cliente</th>
            <th>N° Doc</th>
            <th>Asunto</th>
            <th>Detalle</th>
            <th>Adjunt</th>
            <th>Gestión</th>
             <th>Derivar</th>
            <th>Archivar</th>
           
        </tr>
    </thead>
    <tbody>
        <?php foreach($listado as $k=>$v){ 
            $bgclass = $v['estado']==1?"bg-warning":"bg-success";
            $texto = $v['estado']==0?"Archivar":"Activar";
            $estado = $v['estado']==0?3:0;

            $bgclasstr = $v['estado']==0?"text-danger":"";
            ?>
            <tr class="<?= $bgclasstr ?>">
                <td><?= $v['idexpediente'] ?></td>
                <td><?= $v['fechasys'] ?></td>
                <td><?= $v['nombre'] ?></td>
                <td><?= $v['nroexpediente'] ?></td>
                <td><?= $v['asunto'] ?></td>
                <td><?= $v['detalle'] ?></td>
                <td><button onclick="SubirDocumento(<?= $v['idexpediente'] ?>)" class="btn bg-navy btn-sm" ><span class="fas fa-paperclip" ></span></button></td>
                <td><?= $v['proveido'] ?></td>
                                
                <td><button onclick="EditarExpediente(<?= $v['idexpediente'] ?>)" class="btn bg-info btn-sm"><span class="fas fa-share" ></span></button></td>
                <td><button onclick="archivarExpediente(<?= $v['idexpediente'] ?>)" class="btn bg-warning btn-sm"><span class="fas fa-folder-open" ></span></button></td>
                <!-- <td><button onclick="CambiarEstadoExpediente(<?= $v['idexpediente'] ?>,3,'<?= $v['nroexpediente'] ?>')" class="btn bg-warning btn-sm">Archivar</button></td> -->
                
            </tr>
        <?php }?>
    </tbody>
</table>
<script>
$('#tablaExpedProceso').DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "order":[[0,'desc']],
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tablaExpedProceso_wrapper .col-md-6:eq(0)');

function EditarExpediente(idexpediente){
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data:{
            'proceso': "CONSULTAR",
            'idexpediente': idexpediente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idexpediente").val(resultado.idexpediente);
        $("#origen").val(resultado.origen);
        $("#idcliente").val(resultado.idcliente);
        $("#fechasys").val(resultado.fechasys);
        $("#fechaexpediente").val(resultado.fechaexpediente);
        $("#idtipodoc").val(resultado.idtipodoc);
        $("#nroexpediente").val(resultado.nroexpediente);
        $("#asunto").val(resultado.asunto);
        $("#detalle").val(resultado.detalle);
        $("#folios").val(resultado.folios);
        $("#link").val(resultado.link);
        $("#diasatencion").val(resultado.diasatencion);
        $("#idarea").val("");
        $("#idtramite").val(resultado.idtramite);
        $("#proveido").val(resultado.proveido);
        $("#estado").val(resultado.estado);
        $("#idtipodocumento").val(EditarCliente(resultado.idcliente));
        
        $("#modalExpediente").modal('show');
    });
}

function archivarExpediente(idexpediente){
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data:{
            'proceso': "CONSULTAR",
            'idexpediente': idexpediente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#idexpedientea").val(resultado.idexpediente);
        $("#origena").val(resultado.origen);
        $("#idclientea").val(resultado.idcliente);
        $("#fechasysa").val(resultado.fechasys);
        $("#fechaexpedientea").val(resultado.fechaexpediente);
        $("#idtipodoca").val(resultado.idtipodoc);
        $("#nroexpedientea").val(resultado.nroexpediente);
        $("#asuntoa").val(resultado.asunto);
        $("#detallea").val(resultado.detalle);
        $("#foliosa").val(resultado.folios);
        $("#linka").val(resultado.link);
        $("#diasatenciona").val(resultado.diasatencion);
        $("#idareaa").val("");
        $("#idtramitea").val(resultado.idtramite);
        //$("#proveidoa").val(resultado.proveido);
        $("#estadoa").val(resultado.estado);
        $("#idtipodocumentoa").val(EditarClienteArchivo(resultado.idcliente));
        
        $("#modalExpedienteArchivar").modal('show');
    });
}

function EditarCliente(idcliente){
    $.ajax({
        method: "POST",
        url: "controlador/contCliente.php",
        data:{
            'proceso': "CONSULTAR",
            'idcliente': idcliente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#nombre").val(resultado.nombre);
        $("#idtipodocumento").val(resultado.idtipodocumento);
        $("#nrodocumento").val(resultado.nrodocumento);
        $("#direccion").val(resultado.direccion);
        $("#estado").val(resultado.estado);
        $("#idcliente").val(resultado.idcliente);
        $("#modalCliente").modal('show');
    });
}

function EditarClienteArchivo(idcliente){
    $.ajax({
        method: "POST",
        url: "controlador/contCliente.php",
        data:{
            'proceso': "CONSULTAR",
            'idcliente': idcliente
        },
        dataType: "json"
    }).done(function(resultado){
        $("#nombrea").val(resultado.nombre);
        $("#idtipodocumentoa").val(resultado.idtipodocumento);
        $("#nrodocumentoa").val(resultado.nrodocumento);
        $("#direcciona").val(resultado.direccion);
        $("#estadoa").val(resultado.estado);
        $("#idclientea").val(resultado.idcliente);
      
    });
}

function CambiarEstadoExpediente(idexpediente, estado, nroexpediente){
    proceso = estado==3?"ARCHIVAR":"ACTIVAR";
    mensaje = "¿Esta seguro de <b>"+proceso+"</B> el expediente <b>"+nroexpediente+"</b>?";
    accion = "EjecutarCambiarEstadoExpediente("+idexpediente+",'"+proceso+"')";
    mostrarModalConfirmacion(mensaje, accion);
}

function EjecutarCambiarEstadoExpediente(idexpediente,proceso){    
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data: {
            'proceso': proceso,
            'idexpediente': idexpediente
        }
    }).done(function(resultado){
        if(resultado==1){
            toastCorrecto("Cambio de estado satisfactorio.");
            listarExpedientes();
        }else{
            toastError("Problemas en la actualización de estado. Inténtelo nuevamente.");
        }
    });
}

function SubirDocumento(idexpediente){
    $.ajax({
        method: "POST",
        url: "controlador/contExpediente.php",
        data:{
            'proceso': "CONSULTAR",
            'idexpediente': idexpediente
        },
        dataType: "json"
    }).done(function(resultado){
       
        $("#idexpediente_documento").val(resultado.idexpediente);
        $("#nombre_documento").val(resultado.nombre);
        $("#urdocumento").val(resultado.urldocumento);
        DefinirFileInput();
         $("#modaldocumento").modal('show');
        listarExpedientesModal();
    });
   
}
</script>